/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.goal.bee;

import com.faboslav.friendsandfoes.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.mixin.BeeEntityAccessor;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4051;
import net.minecraft.class_4466;
import org.jetbrains.annotations.Nullable;

public final class BeePollinateMoobloomGoal
extends class_1352 {
    private final class_4051 VALID_MOOBLOOM_PREDICATE = class_4051.method_36626().method_18424();
    private final class_4466 beeEntity;
    private final BeeEntityAccessor beeEntityAccessor;
    private MoobloomEntity moobloom;
    private boolean running;
    private int ticks = 0;
    private int pollinationTicks = 0;
    private int lastPollinationTick = 0;

    public BeePollinateMoobloomGoal(class_4466 beeEntity, BeeEntityAccessor beeEntityAccessor) {
        this.beeEntity = beeEntity;
        this.beeEntityAccessor = beeEntityAccessor;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.beeEntityAccessor.getTicksUntilCanPollinate() > 0) {
            return false;
        }
        if (this.beeEntity.method_29511()) {
            return false;
        }
        if (this.beeEntity.method_21784()) {
            return false;
        }
        if (this.beeEntity.field_6002.method_8419()) {
            return false;
        }
        if (RandomGenerator.generateRandomFloat() < 0.5f) {
            return false;
        }
        if (this.beeEntity.field_21079.method_23346()) {
            return false;
        }
        MoobloomEntity moobloom = this.findMoobloom();
        if (moobloom == null) {
            return false;
        }
        this.moobloom = moobloom;
        class_243 moobloomPollinationPos = this.getMoobloomPollinationPos();
        this.beeEntity.method_5942().method_6337(moobloomPollinationPos.method_10216(), moobloomPollinationPos.method_10214(), moobloomPollinationPos.method_10215(), (double)1.2f);
        return true;
    }

    public boolean method_6266() {
        if (!this.isRunning()) {
            return false;
        }
        if (this.beeEntity.method_29511()) {
            return false;
        }
        if (this.beeEntity.method_5770().method_8419()) {
            return false;
        }
        if (this.completedPollination()) {
            return this.beeEntity.method_6051().method_43057() < 0.2f;
        }
        if (this.getMoobloom() == null) {
            return false;
        }
        return this.moobloom.method_5805();
    }

    public void method_6269() {
        this.pollinationTicks = 0;
        this.ticks = 0;
        this.lastPollinationTick = 0;
        this.setIsRunning(true);
        this.beeEntity.method_21780();
    }

    public void cancel() {
        this.setIsRunning(false);
    }

    public void method_6270() {
        if (this.completedPollination()) {
            this.pollinate();
            this.beeEntityAccessor.invokeSetHasNectar(true);
        }
        this.setIsRunning(false);
        this.beeEntity.method_5942().method_6340();
        this.beeEntityAccessor.setTicksUntilCanPollinate(200);
    }

    public void method_6268() {
        ++this.ticks;
        if (this.ticks > 600) {
            this.setMoobloom(null);
            return;
        }
        class_243 moobloomPollinationPos = this.getMoobloomPollinationPos();
        double dinstanceToMoobloom = this.beeEntity.method_19538().method_1022(moobloomPollinationPos);
        if (dinstanceToMoobloom >= 0.5) {
            this.beeEntity.method_5962().method_6239(moobloomPollinationPos.method_10216(), moobloomPollinationPos.method_10214(), moobloomPollinationPos.method_10215(), 0.9);
            this.beeEntity.method_5988().method_20248(moobloomPollinationPos.method_10216(), this.getMoobloom().method_23318(), moobloomPollinationPos.method_10215());
        }
        if (dinstanceToMoobloom <= 1.5) {
            ++this.pollinationTicks;
            if (this.beeEntity.method_6051().method_43057() < 0.05f && this.pollinationTicks > this.lastPollinationTick + 60) {
                this.lastPollinationTick = this.pollinationTicks;
                this.beeEntity.method_5783(class_3417.field_20607, 1.0f, 1.0f);
            }
        }
    }

    private void pollinate() {
        for (int i = 0; i < 7; ++i) {
            double d = this.beeEntity.method_6051().method_43059() * 0.02;
            double e = this.beeEntity.method_6051().method_43059() * 0.02;
            double f = this.beeEntity.method_6051().method_43059() * 0.02;
            ((class_3218)this.beeEntity.field_6002).method_14199((class_2394)class_2398.field_11201, this.beeEntity.method_23322(1.0), this.beeEntity.method_23319() + 0.5, this.beeEntity.method_23325(1.0), 1, d, e, f, 1.0);
        }
    }

    @Nullable
    private MoobloomEntity findMoobloom() {
        List moobloomEntities = this.beeEntity.field_6002.method_18466(MoobloomEntity.class, this.VALID_MOOBLOOM_PREDICATE, (class_1309)this.beeEntity, this.beeEntity.method_5829().method_1014(32.0));
        double d = Double.MAX_VALUE;
        MoobloomEntity closestMoobloomEntity = null;
        for (MoobloomEntity moobloomEntity : moobloomEntities) {
            if (moobloomEntity.method_6109() || !(this.beeEntity.method_5858((class_1297)moobloomEntity) < d)) continue;
            closestMoobloomEntity = moobloomEntity;
            d = this.beeEntity.method_5858((class_1297)moobloomEntity);
        }
        return closestMoobloomEntity;
    }

    private class_243 getMoobloomPollinationPos() {
        double moobloomPollinationYPos = this.getMoobloom().method_23318() + (double)this.getMoobloom().method_17682() * 1.5;
        return new class_243(this.getMoobloom().method_23317(), moobloomPollinationYPos, this.getMoobloom().method_23321());
    }

    private boolean completedPollination() {
        return this.pollinationTicks > 200;
    }

    private boolean isRunning() {
        return this.running;
    }

    private void setIsRunning(boolean isRunning) {
        this.running = isRunning;
    }

    public MoobloomEntity getMoobloom() {
        return this.moobloom;
    }

    public void setMoobloom(MoobloomEntity moobloomEntity) {
        this.moobloom = moobloomEntity;
    }
}

